<?php

declare(strict_types=1);

namespace IssetBV\Queuing\MessageBundle\Command;

use IssetBV\Queuing\Message\DeQueuer\DeQueuerInterface;
use IssetBV\Queuing\Message\DeQueuer\StatisticInterface;
use IssetBV\Queuing\MessageBundle\DependencyInjection\IssetBVQueuingMessageExtension;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class QueuingDeQueueContinuesCommand extends ContainerAwareCommand
{
    protected function configure()
    {
        $this
            ->setName('issetbv:queuing:dequeue:continues')
            ->addArgument('consumer', InputArgument::OPTIONAL)
            ->setDescription('de queues a message for the given queue')
            ->addOption('timeout', 'ti', InputOption::VALUE_OPTIONAL, 'timeout time in ms', 1000)
            ->addOption('wait_time_no_message_ms', 'wt', InputOption::VALUE_OPTIONAL, 'Wait time if there are no messages on the queue', 0)
            ->addOption('message_limit', 'ml', InputOption::VALUE_OPTIONAL, 'maximum amount of messages to process default is endless');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $timeout = (int) $input->getOption('timeout');
        $messageLimit = $input->getOption('message_limit');
        $waitTimeNoMessageMS = (int) $input->getOption('wait_time_no_message_ms');

        if (null !== $input->getArgument('consumer')) {
            $id = IssetBVQueuingMessageExtension::PREFIX . 'dequeuer.' . $input->getArgument('consumer');
        } else {
            $id = DeQueuerInterface::class;
        }
        $deQueuer = $this->getContainer()->get($id);
        /* @var $deQueuer DeQueuerInterface */
        if (null === $messageLimit) {
            while (true) {
                $this->dequeue($deQueuer, $timeout, $waitTimeNoMessageMS);
            }
        } else {
            while (0 !== $messageLimit) {
                $messageLimit -= $this->dequeue($deQueuer, $timeout, $waitTimeNoMessageMS)->amountReceived();
            }
        }
    }

    private function dequeue(DeQueuerInterface $deQueuer, int $timeout, int $waitTimeNoMessageMS): StatisticInterface
    {
        $statistic = $deQueuer->dequeue($timeout);
        if ($waitTimeNoMessageMS > 0 && 0 === $statistic->amountReceived()) {
            usleep($waitTimeNoMessageMS * 1000);
        }

        return $statistic;
    }
}
