<?php

declare(strict_types=1);

namespace IssetBV\Queuing\MessageBundle\Command;

use IssetBV\Queuing\Message\DeQueuer\DeQueuerInterface;
use IssetBV\Queuing\MessageBundle\DependencyInjection\IssetBVQueuingMessageExtension;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class QueuingDeQueueCommand extends ContainerAwareCommand
{
    protected function configure()
    {
        $this
            ->setName('issetbv:queuing:dequeue')
            ->addArgument('consumer', InputArgument::OPTIONAL)
            ->setDescription('de queues a message for the given queue')
            ->addOption('timeout', 'ti', InputOption::VALUE_OPTIONAL, 'timeout time in ms', 1000);
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $timeout = (int) $input->getOption('timeout');

        if (null !== $input->getArgument('consumer')) {
            $id = IssetBVQueuingMessageExtension::PREFIX . 'dequeuer.' . $input->getArgument('consumer');
        } else {
            $id = DeQueuerInterface::class;
        }
        /* @var $statistic \IssetBV\Queuing\Message\DeQueuer\Statistic */
        $dequeuer = $this->getContainer()->get($id);
        $statistic = $dequeuer->dequeue($timeout);

        $output->writeln($statistic->amountReceived());
    }
}
