<?php

declare(strict_types=1);

namespace IssetBV\Queuing\MessageBundle\Command;

use IssetBV\Queuing\Message\DeQueuer\DeQueuerInterface;
use IssetBV\Queuing\MessageBundle\DependencyInjection\IssetBVQueuingMessageExtension;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class QueuingDeQueueContinuesCommand extends ContainerAwareCommand
{
    protected function configure()
    {
        $this
            ->setName('issetbv:queuing:dequeue:continues')
            ->addArgument('consumer', InputArgument::OPTIONAL)
            ->setDescription('de queues a message for the given queue')
            ->addOption('timeout', 'ti', InputOption::VALUE_OPTIONAL, 'timeout time in ms', 1000)
            ->addOption('message_limit', 'ml', InputOption::VALUE_OPTIONAL, 'maximum amount of messages to process default is endless');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $timeout = (int) $input->getOption('timeout');
        $messageLimit = $input->getOption('message_limit');

        if (null !== $input->getArgument('consumer')) {
            $id = IssetBVQueuingMessageExtension::PREFIX . 'dequeuer.' . $input->getArgument('consumer');
        } else {
            $id = DeQueuerInterface::class;
        }
        /* @var $statistic \IssetBV\Queuing\Message\DeQueuer\Statistic */
        $dequeuer = $this->getContainer()->get($id);

        if (null === $messageLimit) {
            while (true) {
                $dequeuer->dequeue($timeout);
            }
        } else {
            while (0 !== $messageLimit--) {
                $dequeuer->dequeue($timeout);
            }
        }

        $output->writeln($statistic->amountReceived());
    }
}
