<?php

declare(strict_types=1);

namespace IssetBV\Queuing\MessageBundle\Command;

use IssetBV\Queuing\MessageBundle\DependencyInjection\IssetBVQueuingMessageExtension;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class MessageConsumerCommand extends ContainerAwareCommand
{
    protected function configure()
    {
        $this
            ->setName('issetbv:message:dequeue')
            ->addArgument('consumer', InputArgument::REQUIRED)
            ->setDescription('dequeues a message for the given consumer')
            ->addOption('timeout', 'ti', InputOption::VALUE_OPTIONAL, 'timeout time in ms', 1000);
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $timeout = (int) $input->getOption('timeout');
        $statistic = $this->getContainer()->get(IssetBVQueuingMessageExtension::PREFIX . 'dequeuer.' . $input->getArgument('consumer'))->dequeue($timeout);
        /* @var $statistic \IssetBV\Queuing\Message\DeQueuer\Statistic */

        $output->writeln($statistic->amountReceived());
    }
}
