<?php

declare(strict_types=1);

namespace IssetBV\Queuing\MessageBundle\Compiler;

use IssetBV\Queuing\MessageBundle\DependencyInjection\IssetBVQueuingMessageExtension;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

class MessageBundleCompilerPass implements CompilerPassInterface
{
    /**
     * You can modify the container here before it is dumped to PHP code.
     *
     * @param ContainerBuilder $container
     *
     * @throws \Symfony\Component\DependencyInjection\Exception\ServiceNotFoundException
     * @throws \Symfony\Component\DependencyInjection\Exception\InvalidArgumentException
     */
    public function process(ContainerBuilder $container)
    {
        $this->buildEncoders($container);
        $this->buildDecoders($container);
        $this->buildConsumers($container);
    }

    private function buildEncoders(ContainerBuilder $container)
    {
        $definition = $container->findDefinition(IssetBVQueuingMessageExtension::ENCODER_CONTAINER_DEFAULT);
        $taggedServices = $container->findTaggedServiceIds(IssetBVQueuingMessageExtension::PREFIX . 'encoder');
        foreach (array_keys($taggedServices) as $id) {
            $definition->addMethodCall('add', [
                new Reference($id),
            ]);
        }
    }

    private function buildDecoders(ContainerBuilder $container)
    {
        $definition = $container->findDefinition(IssetBVQueuingMessageExtension::DECODER_CONTAINER_DEFAULT);
        $taggedServices = $container->findTaggedServiceIds(IssetBVQueuingMessageExtension::PREFIX . 'decoder');
        foreach (array_keys($taggedServices) as $id) {
            $definition->addMethodCall('add', [
                new Reference($id),
            ]);
        }
    }

    private function buildConsumers(ContainerBuilder $container)
    {
        $definition = $container->findDefinition(IssetBVQueuingMessageExtension::CONSUMER_CONTAINER_DEFAULT);
        $taggedServices = $container->findTaggedServiceIds(IssetBVQueuingMessageExtension::PREFIX . 'consumer');
        foreach (array_keys($taggedServices) as $id) {
            $definition->addMethodCall('add', [
                new Reference($id),
            ]);
        }
    }
}
