<?php

declare(strict_types=1);

namespace IssetBV\Queuing\MessageBundle\Command;

use IssetBV\Queuing\MessageBundle\DependencyInjection\IssetBVQueuingMessageExtension;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class MessageConsumerCommand extends ContainerAwareCommand
{
    protected function configure()
    {
        $this
            ->setName('issetbv:message:dequeue')
            ->addArgument('consumer', InputArgument::REQUIRED)
            ->setDescription('dequeues a message for the given consumer');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->getContainer()->get(IssetBVQueuingMessageExtension::PREFIX . 'dequeuer.' . $input->getArgument('consumer'))->dequeue();
    }
}
