<?php

declare(strict_types=1);

namespace IssetBV\Queuing\Message\Queuer;

use IssetBV\Queuing\Message\Encoder\EncoderContainerInterface;
use IssetBV\Queuing\Message\MessageInterface;
use IssetBV\Queuing\Queue\QueueInterface;

class Queuer implements QueuerInterface
{
    /**
     * @var EncoderContainerInterface
     */
    private $encoderContainer;
    /**
     * @var QueueInterface
     */
    private $queue;

    public function __construct(EncoderContainerInterface $encoderContainer, QueueInterface $queue)
    {
        $this->encoderContainer = $encoderContainer;
        $this->queue = $queue;
    }

    public function queue(MessageInterface $message, array $headers = [])
    {
        $messageString = $this->encoderContainer->encode($message);

        $headers[MessageInterface::HEADER_VERSION] = $message->getVersion();
        $headers[MessageInterface::HEADER_TYPE] = $message->getType();

        $this->queue->send($messageString, $headers);
    }
}
