<?php

declare(strict_types=1);

namespace IssetBV\Queuing\Message\Encoder;

use IssetBV\Queuing\Message\Encoder\Exception\EncoderNotFoundException;
use IssetBV\Queuing\Message\MessageInterface;

class EncoderContainer implements EncoderContainerInterface
{
    /**
     * @var EncoderInterface[]
     */
    private $encoders = [];
    /**
     * @var EncoderInterface|null
     */
    private $encoderDefault;

    public function __construct(EncoderInterface $encoderDefault = null)
    {
        $this->encoderDefault = $encoderDefault;
    }

    public function get(MessageInterface $message): EncoderInterface
    {
        foreach ($this->encoders as $encoder) {
            if ($encoder->encodes($message)) {
                return $encoder;
            }
        }

        if (null !== $this->encoderDefault) {
            return $this->encoderDefault;
        }

        throw new EncoderNotFoundException('No encoder found for type: ' . $message->getType() . ' version: ' . $message->getVersion() . ' class: ' . \get_class($message));
    }

    public function add(EncoderInterface $encoder)
    {
        $this->encoders[] = $encoder;
    }

    public function encode(MessageInterface $message): string
    {
        return $this->get($message)->encode($message);
    }
}
