<?php

declare(strict_types=1);

namespace IssetBV\Queuing\Message\Consumer;

class ResponseAggregate implements ResponseInterface
{
    /**
     * @var string|null
     */
    private $state;

    public function addResponse(ResponseInterface $response)
    {
        if (null === $this->state) {
            $this->state = $response->getState();

            return;
        }

        switch ($response->getState()) {
            case ResponseInterface::STATE_REJECT:
                $this->setReject();
                break;
            case ResponseInterface::STATE_REQUEUE:
                $this->setRequeue();
                break;
        }
    }

    public function getState(): string
    {
        if (null === $this->state) {
            throw new \RuntimeException('no state');
        }

        return $this->state;
    }

    public function stopPropagation(): bool
    {
        return false;
    }

    private function setReject()
    {
        if (ResponseInterface::STATE_REQUEUE !== $this->state) {
            $this->state = ResponseInterface::STATE_REJECT;
        }
    }

    private function setRequeue()
    {
        $this->state = ResponseInterface::STATE_REQUEUE;
    }
}
