<?php

declare(strict_types=1);

namespace IssetBV\Queuing\Message\Consumer;

use IssetBV\Queuing\Message\Consumer\Exception\ConsumerNotFoundException;
use IssetBV\Queuing\Message\MessageInterface;

interface ConsumerContainerInterface
{
    /**
     * @param MessageInterface $message
     *
     * @throws ConsumerNotFoundException
     *
     * @return ResponseInterface
     */
    public function consume(MessageInterface $message): ResponseInterface;

    public function add(ConsumerInterface $consumer);

    public function addPreConsume(PreConsumeInterface $preConsume);

    public function addPostConsume(PostConsumeInterface $postConsume);
}
