<?php

declare(strict_types=1);

namespace IssetBV\Queuing\Message\Decoder;

class DecoderData implements DecoderDataInterface
{
    /**
     * @var string
     */
    private $type;
    /**
     * @var string
     */
    private $version;
    /**
     * @var string
     */
    private $data;

    public function __construct(string $type, string $version, string $data)
    {
        $this->type = $type;
        $this->version = $version;
        $this->data = $data;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @return string
     */
    public function getVersion(): string
    {
        return $this->version;
    }

    /**
     * @return string
     */
    public function getData(): string
    {
        return $this->data;
    }
}
