<?php

declare(strict_types=1);

namespace IssetBV\Queuing\Message\Consumer;

class Response implements ResponseInterface
{
    /**
     * @var string
     */
    private $state;
    /**
     * @var bool
     */
    private $stopPropagation;

    public function __construct(string $state, bool $stopPropagation = false)
    {
        $this->state = $state;
        $this->stopPropagation = $stopPropagation;
    }

    public function getState(): string
    {
        return $this->state;
    }

    public static function accept(bool $stopPropagation = false): ResponseInterface
    {
        return new self(ResponseInterface::STATE_ACCEPT, $stopPropagation);
    }

    public static function reject(bool $stopPropagation = false): ResponseInterface
    {
        return new self(ResponseInterface::STATE_REJECT, $stopPropagation);
    }

    public static function requeue(bool $stopPropagation = false): ResponseInterface
    {
        return new self(ResponseInterface::STATE_REQUEUE, $stopPropagation);
    }

    public function stopPropagation(): bool
    {
        return $this->stopPropagation;
    }
}
