<?php

declare(strict_types=1);

namespace IssetBV\Queuing\Message\DeQueuer;

class Statistic implements StatisticInterface
{
    /**
     * @var int
     */
    private $startTime;
    /**
     * @var int
     */
    private $stopTime;

    private $amountReceived = 0;

    public function addReceived()
    {
        ++$this->amountReceived;
    }

    public function startTimer()
    {
        $this->startTime = time();
    }

    public function stopTimer()
    {
        $this->stopTime = time();
    }

    public function amountReceived(): int
    {
        return $this->amountReceived;
    }

    public function spendTime(): int
    {
        if (null === $this->startTime) {
            throw new \LogicException('DequeuerStats Timer not started');
        }

        if (null === $this->stopTime) {
            throw new \LogicException('DequeuerStats Timer not stopped');
        }

        return $this->stopTime - $this->startTime;
    }
}
