<?php

declare(strict_types=1);

namespace IssetBV\Queuing\Message\DeQueuer;

use IssetBV\Queuing\Queue\QueueInterface;
use IssetBV\Queuing\Queue\QueueMessageInterface;
use Throwable;

class DeQueuerExceptionHandlerData implements DeQueuerExceptionHandlerDataInterface
{
    /**
     * @var QueueInterface
     */
    private $queue;
    /**
     * @var QueueMessageInterface
     */
    private $message;
    /**
     * @var Throwable
     */
    private $exception;

    public function __construct(QueueInterface $queue, QueueMessageInterface $message, Throwable $exception)
    {
        $this->queue = $queue;
        $this->message = $message;
        $this->exception = $exception;
    }

    /**
     * @return QueueInterface
     */
    public function getQueue(): QueueInterface
    {
        return $this->queue;
    }

    /**
     * @return QueueMessageInterface
     */
    public function getMessage(): QueueMessageInterface
    {
        return $this->message;
    }

    /**
     * @return Throwable
     */
    public function getException(): Throwable
    {
        return $this->exception;
    }
}
