<?php

declare(strict_types=1);

namespace IssetBV\Queuing\Message\Consumer;

class Response implements ResponseInterface
{
    /**
     * @var string
     */
    private $state;

    /**
     * Response constructor.
     *
     * @param $state
     */
    public function __construct(string $state)
    {
        $this->state = $state;
    }

    public function getState(): string
    {
        return $this->state;
    }

    public static function accept(): ResponseInterface
    {
        return new self(ResponseInterface::STATE_ACCEPT);
    }

    public static function reject(): ResponseInterface
    {
        return new self(ResponseInterface::STATE_REJECT);
    }

    public static function requeue(): ResponseInterface
    {
        return new self(ResponseInterface::STATE_REQUEUE);
    }
}
