<?php

declare(strict_types=1);

namespace IssetBV\Queuing\Message\Consumer;

use IssetBV\Queuing\Message\Consumer\Exception\ConsumerNotFoundException;
use IssetBV\Queuing\Message\MessageInterface;

class ConsumerContainer implements ConsumerContainerInterface
{
    /**
     * @var ConsumerInterface[]
     */
    private $consumers = [];

    /**
     * @param ConsumerInterface $consumer
     */
    public function add(ConsumerInterface $consumer)
    {
        $this->consumers[] = $consumer;
    }

    /**
     * @param MessageInterface $message
     *
     * @throws ConsumerNotFoundException
     *
     * @return ResponseInterface
     */
    public function consume(MessageInterface $message): ResponseInterface
    {
        $response = new ResponseAggregate();
        $consumed = false;

        foreach ($this->consumers as $consumer) {
            if ($consumer->consumes($message)) {
                $response->addResponse($consumer->consume($message));
                $consumed = true;
            }
        }

        if (!$consumed) {
            throw new ConsumerNotFoundException('Consumer not found');
        }

        return $response;
    }
}
