<?php

declare(strict_types=1);

namespace IssetBV\Queuing\Message\DeQueuer;

use IssetBV\Queuing\Queue\QueueInterface;
use IssetBV\Queuing\Queue\QueueMessageInterface;
use Throwable;

interface DeQueuerExceptionHandlerDataInterface
{
    /**
     * @return QueueInterface
     */
    public function getQueue(): QueueInterface;

    /**
     * @return QueueMessageInterface
     */
    public function getMessage(): QueueMessageInterface;

    /**
     * @return Throwable
     */
    public function getException(): Throwable;
}
