<?php

declare(strict_types=1);

namespace IssetBV\Queuing\Message\Decoder;

use IssetBV\Queuing\Message\Decoder\Exception\DecoderNotFoundException;
use IssetBV\Queuing\Message\MessageInterface;

class DecoderContainer implements DecoderContainerInterface
{
    /**
     * @var DecoderInterface[]
     */
    private $decoders = [];
    /**
     * @var DecoderInterface|null
     */
    private $decoderDefault;

    public function __construct(DecoderInterface $decoderDefault = null)
    {
        $this->decoderDefault = $decoderDefault;
    }

    /**
     * @param DecoderData $decoderData
     *
     * @throws DecoderNotFoundException
     *
     * @return DecoderInterface
     */
    public function get(DecoderData $decoderData): DecoderInterface
    {
        foreach ($this->decoders as $decoder) {
            if ($decoder->decodes($decoderData)) {
                return $decoder;
            }
        }

        if (null !== $this->decoderDefault && $this->decoderDefault->decodes($decoderData)) {
            return $this->decoderDefault;
        }

        throw new DecoderNotFoundException('No decoder found for type: ' . $decoderData->getType() . ' version: ' . $decoderData->getVersion());
    }

    /**
     * @param DecoderInterface $decoder
     */
    public function add(DecoderInterface $decoder)
    {
        $this->decoders[] = $decoder;
    }

    /**
     * @param DecoderData $decoderData
     *
     * @throws DecoderNotFoundException
     *
     * @return MessageInterface
     */
    public function decode(DecoderData $decoderData): MessageInterface
    {
        return $this->get($decoderData)->decode($decoderData);
    }
}
