<?php

declare(strict_types=1);

namespace IssetBV\Queuing\Message\Consumer;

use IssetBV\Queuing\Message\Consumer\Exception\ConsumerNotFoundException;
use IssetBV\Queuing\Message\MessageInterface;

class ConsumerContainer implements ConsumerContainerInterface
{
    /**
     * @var ConsumerInterface[]
     */
    private $consumers = [];

    /**
     * @param MessageInterface $message
     *
     * @throws ConsumerNotFoundException
     *
     * @return ConsumerInterface
     */
    public function get(MessageInterface $message): ConsumerInterface
    {
        foreach ($this->consumers as $consumer) {
            if ($consumer->consumes($message)) {
                return $consumer;
            }
        }

        throw new ConsumerNotFoundException('Consumer not found');
    }

    /**
     * @param ConsumerInterface $consumer
     */
    public function add(ConsumerInterface $consumer)
    {
        $this->consumers[] = $consumer;
    }

    /**
     * @param MessageInterface $message
     *
     * @throws ConsumerNotFoundException
     *
     * @return ResponseInterface
     */
    public function consume(MessageInterface $message): ResponseInterface
    {
        return $this->get($message)->consume($message);
    }
}
