<?php

declare(strict_types=1);

namespace IssetBV\Queuing\KafkaBundle\Kafka;

class QueueMessage implements \JsonSerializable
{
    private $message;
    private $headers;

    /**
     * QueueMessage constructor.
     *
     * @param $message
     * @param array $headers
     */
    public function __construct($message, array $headers)
    {
        $this->message = $message;
        $this->headers = $headers;
    }

    /**
     * Specify data which should be serialized to JSON.
     *
     * @see http://php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed data which can be serialized by <b>json_encode</b>,
     * which is a value of any type other than a resource
     *
     * @since 5.4.0
     */
    public function jsonSerialize()
    {
        return [
            'message' => $this->message,
            'headers' => empty($this->headers) ? new \stdClass() : $this->headers,
        ];
    }
}
