<?php

declare(strict_types=1);

namespace IssetBV\Queuing\KafkaBundle\Kafka;

use IssetBV\Queuing\Queue\QueueMessageInterface;

class Message implements QueueMessageInterface
{
    /**
     * @var string
     */
    private $body;
    /**
     * @var array
     */
    private $headers;
    /**
     * @var array
     */
    private $options;

    public function __construct(string $body, array $headers, array $options)
    {
        $this->body = $body;
        $this->headers = $headers;
        $this->options = $options;
    }

    public function getBody(): string
    {
        return $this->body;
    }

    public function getHeader(string $header)
    {
        if (array_key_exists($header, $this->headers)) {
            return $this->headers[$header];
        }
    }

    public function getOption(string $option)
    {
        if (array_key_exists($option, $this->options)) {
            return $this->options[$option];
        }
    }

    public function hasHeader(string $header): bool
    {
        return array_key_exists($header, $this->headers);
    }

    public function getHeaders(): array
    {
        return $this->headers;
    }

    public static function fromResponse(array $response): self
    {
        $body = $response['message'];
        $headers = $response['headers'] ?? [];
        $options = [
            'key' => $response['key'],
            'offset' => $response['offset'],
        ];

        return new self($body, $headers, $options);
    }
}
