<?php

declare(strict_types=1);

namespace IssetBV\Queuing\KafkaBundle\Kafka;

class KafkaResponse
{
    /**
     * @var string
     */
    private $key;
    /**
     * @var array
     */
    private $recordMeta;

    public function __construct(string $key, array $recordMeta)
    {
        $this->key = $key;
        $this->recordMeta = $recordMeta;
    }

    /**
     * @return string
     */
    public function getKey(): string
    {
        return $this->key;
    }

    /**
     * @return array
     */
    public function getRecordMeta(): array
    {
        return $this->recordMeta;
    }

    public static function fromResponse(array $response): self
    {
        return new self($response['key'], $response['record_metadata']);
    }
}
