<?php

declare(strict_types=1);

namespace IssetBV\Queuing\KafkaBundle\Kafka;

use IssetBV\Queuing\Queue\ConnectionInterface;
use IssetBV\Queuing\Queue\QueueInterface;

class Connection implements ConnectionInterface
{
    /**
     * @var KafkaClient
     */
    private $kafkaClient;
    /**
     * @var string
     */
    private $name;

    public function __construct(KafkaClient $kafkaClient, string $name)
    {
        $this->kafkaClient = $kafkaClient;
        $this->name = $name;
    }

    /**
     * @param string $exchange
     * @param string $queue
     * @param array $options
     *
     * @return Queue
     */
    public function getQueue(string $exchange, string $queue, array $options = []): QueueInterface
    {
        return new Queue($this, $this->kafkaClient, $exchange, $queue);
    }

    public function getName(): string
    {
        return $this->name;
    }
}
