<?php

declare(strict_types=1);

namespace IssetBV\Queuing\KafkaBundle\Kafka;

use IssetBV\Queuing\Queue\QueueMessageInterface;

class Message implements QueueMessageInterface
{
    /**
     * @var
     */
    private $response;

    public function __construct($response)
    {
        $this->response = $response;
    }

    public function getBody(): string
    {
        return $this->response['message'];
    }

    public function getHeader(string $header)
    {
        if (array_key_exists($header, $this->response['headers'])) {
            return $this->response['headers'][$header];
        }
    }

    public function getOption(string $option)
    {
        return null;
    }

    public function hasHeader(string $header): bool
    {
        return array_key_exists($header, $this->response['headers']);
    }

    public function getHeaders(): array
    {
        return $this->response['headers'];
    }
}
