<?php

declare(strict_types=1);

namespace IssetBV\Queuing\KafkaBundle\Kafka;

use IssetBV\Queuing\Queue\ConnectionInterface;
use IssetBV\Queuing\Queue\QueueInterface;

class Connection implements ConnectionInterface
{
    /**
     * @var string
     */
    private $connection;
    /**
     * @var string
     */
    private $baseUrl;
    /**
     * @var string
     */
    private $name;

    public function __construct(string $name, string $baseUrl, string $connection)
    {
        $this->connection = $connection;
        $this->baseUrl = $baseUrl;
        $this->name = $name;
    }

    /**
     * @param string $exchange
     * @param string $queue
     * @param array $options
     *
     * @return Queue
     */
    public function getQueue(string $exchange, string $queue, array $options = []): QueueInterface
    {
        return new Queue($this, $this->baseUrl, $this->connection, $exchange, $queue);
    }

    public function getName(): string
    {
        return $this->name;
    }
}
