<?php

declare(strict_types=1);

namespace IssetBV\Queuing\KafkaBundle\DependencyInjection;

use IssetBV\Queuing\KafkaBundle\Kafka\Connection;
use IssetBV\Queuing\Queue\ConnectionInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

/**
 * This is the class that loads and manages your bundle configuration.
 *
 * @see http://symfony.com/doc/current/cookbook/bundles/extension.html
 */
class IssetBVQueuingKafkaExtension extends Extension
{
    /**
     * @var ContainerBuilder
     */
    private $container;

    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $this->container = $container;

        foreach ($config['connections'] as $connection => $connectionSettings) {
            $this->buildConnection($connection, $connectionSettings);
        }
    }

    private function buildConnection(string $name, array $connectionSettings)
    {
        $connection = $this->container->register(
            ConnectionInterface::CONNECTION_PREFIX . $name,
            Connection::class
        );
        $connection->addArgument($name);
        $connection->addArgument($connectionSettings['base_url']);
        $connection->addArgument($connectionSettings['connection']);
    }
}
