<?php

declare(strict_types=1);

namespace IssetBV\Queuing\JmsBundle\DependencyInjection;

use IssetBV\Queuing\JmsBundle\Service\Decoder;
use IssetBV\Queuing\JmsBundle\Service\DecoderMap;
use IssetBV\Queuing\JmsBundle\Service\Encoder;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\HttpKernel\Kernel;

/**
 * This is the class that loads and manages your bundle configuration.
 *
 * @see http://symfony.com/doc/current/cookbook/bundles/extension.html
 */
class IssetBVQueuingJmsExtension extends Extension
{
    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $encoder = $container->register('isset_bv_queuing_jms.encoder', Encoder::class);
        $encoder->addArgument(new Reference('jms_serializer'));
        $encoder->setLazy(true);

        $encoder = $container->register('isset_bv_queuing_jms.encoder.xml', Encoder::class);
        $encoder->addArgument(new Reference('jms_serializer'));
        $encoder->addArgument('xml');
        $encoder->setLazy(true);

        $decoderMapClass = $config['decoder_map'];

        if (null === $decoderMapClass) {
            $decoderMapClass = 'isset_bv_queuing_jms.decoder_map';
            $decoderMap = $container->register($decoderMapClass, DecoderMap::class);
            $decoderMap->addArgument($config['decode_type']);
            $decoderMap->setLazy(true);
        }

        if (true === $config['auto_tag'] && (Kernel::MAJOR_VERSION > 3 || (Kernel::MAJOR_VERSION === 3 && Kernel::MINOR_VERSION >= 3))) {
            $container->setAlias('isset_bv_queuing_jms.auto_tag_class', $decoderMapClass);
            $container
                ->registerForAutoconfiguration($config['auto_tag_interface'])
                ->addTag($config['auto_tag_name']);
            $container->setParameter('isset_bv_queuing_jms.auto_tag_name', $config['auto_tag_name']);
        }

        $decoder = $container->register('isset_bv_queuing_jms.decoder', Decoder::class);
        $decoder->addArgument(new Reference('jms_serializer'));
        $decoder->addArgument(new Reference($decoderMapClass));
        $decoder->setLazy(true);
    }
}
