<?php

declare(strict_types=1);

namespace IssetBV\Queuing\JmsBundle\DependencyInjection;

use IssetBV\Queuing\Message\MessageInterface;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files.
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/configuration.html}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('isset_bv_queuing_jms');
        $rootNode
            ->children()
            ->scalarNode('decoder_map')->defaultNull()->end()
            ->scalarNode('auto_tag')->defaultTrue()->end()
            ->scalarNode('auto_tag_interface')->defaultValue(MessageInterface::class)->end()
            ->scalarNode('auto_tag_name')->defaultValue('decoder_mapper_default')->end()
            ->scalarNode('decode_type')->defaultValue('json')->end()
            ->end();

        // Here you should define the parameters that are allowed to
        // configure your bundle. See the documentation linked above for
        // more information on that topic.

        return $treeBuilder;
    }
}
