<?php

declare(strict_types=1);

namespace IssetBV\Queuing\JmsBundle\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

class DecoderMapCompilerPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container)
    {
        $tag = 'isset_bv_queuing_jms.auto_tag_class';
        if (!$container->has($tag)) {
            return;
        }
        $definition = $container->findDefinition($tag);
        $taggedServices = $container->findTaggedServiceIds($container->getParameter('isset_bv_queuing_jms.auto_tag_name'));

        foreach (array_keys($taggedServices) as $id) {
            $definition->addMethodCall('add', [
                $container->findDefinition($id),
            ]);
        }
    }
}
