<?php

declare(strict_types=1);

namespace IssetBV\Queuing\JmsBundle\Service;

use IssetBV\Queuing\Message\Decoder\DecoderDataInterface;
use IssetBV\Queuing\Message\MessageInterface;

class DecoderMap implements DecoderMapInterface
{
    /**
     * @var DecoderMapDataInterface[]
     */
    private $map = [];
    /**
     * @var string
     */
    private $defaultType;

    public function __construct(array $map, string $defaultType)
    {
        foreach ($map as $className => $item) {
            $class = $item['class'] ?? $className;
            /* @var MessageInterface $class */
            $data = new DecoderMapData($class, $item['decode_type'] ?? $defaultType);
            $this->set($class::getType(), $class::getVersion(), $data);
        }
        $this->defaultType = $defaultType;
    }

    public function set(string $type, string $version, DecoderMapData $data)
    {
        $key = $this->getKey($type, $version);
        if (!array_key_exists($key, $this->map)) {
            $this->map[$key] = $data;
        }
    }

    public function add(string $class)
    {
        /* @var MessageInterface $class */
        $data = new DecoderMapData($class, $this->defaultType);
        $this->set($class::getType(), $class::getVersion(), $data);
    }

    public function getForData(DecoderDataInterface $decoderData): DecoderMapDataInterface
    {
        $key = $this->getKey($decoderData->getType(), $decoderData->getVersion());
        if (!array_key_exists($key, $this->map)) {
            throw new \LogicException('class not found');
        }

        return $this->map[$key];
    }

    public function hasForData(DecoderDataInterface $decoderData)
    {
        return array_key_exists($this->getKey($decoderData->getType(), $decoderData->getVersion()), $this->map);
    }

    public function getKey(string $type, string $version): string
    {
        return sha1($type . ';;' . $version);
    }
}
