<?php

declare(strict_types=1);

namespace IssetBV\Queuing\JmsBundle\Service;

use IssetBV\Queuing\Message\Encoder\EncoderInterface;
use IssetBV\Queuing\Message\MessageInterface;
use JMS\Serializer\SerializerInterface;

class Encoder implements EncoderInterface
{
    /**
     * @var SerializerInterface
     */
    private $serializer;
    /**
     * @var string
     */
    private $format;

    public function __construct(SerializerInterface $serializer, string $format = 'json')
    {
        $this->serializer = $serializer;
        $this->format = $format;
    }

    public function encode(MessageInterface $message): string
    {
        return $this->serializer->serialize($message, $this->format);
    }

    public function encodes(MessageInterface $message): bool
    {
        return true;
    }
}
