<?php

declare(strict_types=1);

namespace IssetBV\Queuing\JmsBundle\Service;

use IssetBV\Queuing\Message\Decoder\DecoderDataInterface;

class DecoderMap implements DecoderMapInterface
{
    /**
     * @var DecoderMapDataInterface[]
     */
    private $map = [];

    public function __construct(array $map, string $defaultType)
    {
        foreach ($map as $className => $item) {
            $class = $item['class'] ?? $className;
            $data = new DecoderMapData($class, $item['decode_type'] ?? $defaultType);

            $this->map[$this->getKey($class::getType(), $class::getVersion())] = $data;
        }
    }

    public function getForData(DecoderDataInterface $decoderData): DecoderMapDataInterface
    {
        $key = $this->getKey($decoderData->getType(), $decoderData->getVersion());
        if (!array_key_exists($key, $this->map)) {
            throw new \LogicException('class not found');
        }

        return $this->map[$key];
    }

    public function hasForData(DecoderDataInterface $decoderData)
    {
        return array_key_exists($this->getKey($decoderData->getType(), $decoderData->getVersion()), $this->map);
    }

    public function getKey(string $type, string $version): string
    {
        return sha1($type . ';;' . $version);
    }
}
