<?php

declare(strict_types=1);

namespace IssetBV\Queuing\JmsBundle\Service;

use IssetBV\Queuing\Message\Decoder\DecoderDataInterface;

class DecoderMap implements DecoderMapInterface
{
    /**
     * @var string[]
     */
    private $map = [];

    public function __construct(array $map)
    {
        foreach ($map as $item) {
            foreach ($item['versions'] as $version) {
                $this->map[$this->getKey($item['type'], $version)] = $item['class'];
            }
        }
    }

    public function getForData(DecoderDataInterface $decoderData): string
    {
        $key = $this->getKey($decoderData->getType(), $decoderData->getVersion());
        if (!array_key_exists($key, $this->map)) {
            throw new \LogicException('class not found');
        }

        return $this->map[$key];
    }

    public function hasForData(DecoderDataInterface $decoderData)
    {
        return array_key_exists($this->getKey($decoderData->getType(), $decoderData->getVersion()), $this->map);
    }

    public function getKey(string $type, string $version): string
    {
        return sha1($type . ';;' . $version);
    }
}
