<?php

declare(strict_types=1);

namespace IssetBV\Queuing\JmsBundle\Service;

use IssetBV\Queuing\Message\Decoder\DecoderDataInterface;
use IssetBV\Queuing\Message\Decoder\DecoderInterface;
use IssetBV\Queuing\Message\MessageInterface;
use JMS\Serializer\SerializerInterface;

class Decoder implements DecoderInterface
{
    /**
     * @var SerializerInterface
     */
    private $serializer;
    /**
     * @var string
     */
    private $format;
    /**
     * @var DecoderMapInterface
     */
    private $decoderMap;

    /**
     * Decoder constructor.
     *
     * @param SerializerInterface $serializer
     * @param DecoderMapInterface $decoderMap
     * @param string $format
     */
    public function __construct(SerializerInterface $serializer, DecoderMapInterface $decoderMap, string $format = 'json')
    {
        $this->serializer = $serializer;
        $this->format = $format;
        $this->decoderMap = $decoderMap;
    }

    public function decode(DecoderDataInterface $decoderData): MessageInterface
    {
        $class = $this->decoderMap->getForData($decoderData);
        $messageData = $this->serializer->deserialize($decoderData->getData(), $class, $this->format);
        if (!($messageData instanceof MessageInterface)) {
            throw new \LogicException('expected: ' . MessageInterface::class . ' got: ' . get_class($messageData));
        }

        return $messageData;
    }

    public function decodes(DecoderDataInterface $decoderData): bool
    {
        return $this->decoderMap->hasForData($decoderData);
    }
}
