<?php

declare(strict_types=1);

namespace IssetBV\Queuing\AmqpBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files.
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/configuration.html}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('isset_bv_queuing_amqp');
        $rootNode
            ->children()
            ->arrayNode('connections')
            ->prototype('array')
            ->children()
            ->scalarNode('host')->isRequired()->end()
            ->scalarNode('port')->defaultValue(5672)->end()
            ->scalarNode('user')->isRequired()->end()
            ->scalarNode('password')->isRequired()->end()
            ->scalarNode('vhost')->defaultValue('/')->end()
            ->scalarNode('insist')->defaultFalse()->end()
            ->scalarNode('login_method')->defaultValue('AMQPLAIN')->end()
            ->scalarNode('login_response')->defaultNull()->end()
            ->scalarNode('locale')->defaultValue('en_US')->end()
            ->scalarNode('connection_timeout')->defaultValue(3.0)->end()
            ->scalarNode('read_write_timeout')->defaultValue(3.0)->end()
            ->scalarNode('context')->defaultNull()->end()
            ->scalarNode('keepalive')->defaultFalse()->end()
            ->scalarNode('heartbeat')->defaultValue(0)->end()
            ->end()
            ->end()
            ->end()
            ->end();

        // Here you should define the parameters that are allowed to
        // configure your bundle. See the documentation linked above for
        // more information on that topic.

        return $treeBuilder;
    }
}
