<?php

declare(strict_types=1);

namespace IssetBV\Queuing\AmqpBundle\AMQP;

class Header
{
    const TYPE_STRING = 'S';
    const TYPE_INTEGER = 'I';
    const TYPE_TIMESTAMP = 'T';
    const TYPE_DECIMAL = 'D';
    const TYPE_TABLE = 'T';
    const TYPE_ARRAY = 'A';

    /**
     * @var mixed
     */
    private $value;
    /**
     * @var string
     */
    private $type;
    /**
     * @var string
     */
    private $header;

    public function __construct(string $header, $value, string $type = null)
    {
        $this->value = $value;
        $this->header = $header;

        if (null === $type) {
            if (\is_int($value)) {
                $this->type = self::TYPE_INTEGER;
            } elseif (\is_float($value)) {
                $this->type = self::TYPE_DECIMAL;
            } else {
                $this->type = self::TYPE_STRING;
            }
        } else {
            $this->type = $type;
        }
    }

    /**
     * @return string
     */
    public function getHeader(): string
    {
        return $this->header;
    }

    /**
     * @return mixed
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }
}
