<?php

declare(strict_types=1);

namespace IssetBV\Queuing\AmqpBundle\AMQP;

class Header
{
    const TYPE_STRING = 'S';
    const TYPE_INTEGER = 'I';
    const TYPE_TIMESTAMP = 'T';
    const TYPE_DECIMAL = 'D';
    const TYPE_TABLE = 'T';
    const TYPE_ARRAY = 'A';

    /**
     * @var string
     */
    private $value;
    /**
     * @var string
     */
    private $type;
    /**
     * @var string
     */
    private $header;

    public function __construct(string $header, string $value, string $type = self::TYPE_STRING)
    {
        $this->value = $value;
        $this->type = $type;
        $this->header = $header;
    }

    /**
     * @return string
     */
    public function getHeader(): string
    {
        return $this->header;
    }

    /**
     * @return string
     */
    public function getValue(): string
    {
        return $this->value;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }
}
