<?php

declare(strict_types=1);

namespace IssetBV\Queuing\AmqpBundle\AMQP;

class ConnectionOptions
{
    /**
     * @var string
     */
    private $host;
    /**
     * @var string
     */
    private $port;
    /**
     * @var string
     */
    private $user;
    /**
     * @var string
     */
    private $password;
    /**
     * @var string
     */
    private $vhost;
    /**
     * @var bool
     */
    private $insist;
    /**
     * @var string
     */
    private $loginMethod;
    /**
     * @var string|null
     */
    private $loginResponse;
    /**
     * @var string
     */
    private $locale;
    /**
     * @var float
     */
    private $connectionTimeout;
    /**
     * @var float
     */
    private $readWriteTimeout;
    /**
     * @var string|null
     */
    private $context;
    /**
     * @var bool
     */
    private $keepalive;
    /**
     * @var int
     */
    private $heartbeat;

    public function __construct(
        string $host,
        string $port,
        string $user,
        string $password,
        string $vhost = '/',
        bool $insist = false,
        string $loginMethod = 'AMQPLAIN',
        string $loginResponse = null,
        string $locale = 'en_US',
        float $connectionTimeout = 3.0,
        float $readWriteTimeout = 3.0,
        string $context = null,
        bool $keepAlive = false,
        int $heartbeat = 0
    ) {
        $this->host = $host;
        $this->port = $port;
        $this->user = $user;
        $this->password = $password;
        $this->vhost = $vhost;
        $this->insist = $insist;
        $this->loginMethod = $loginMethod;
        $this->loginResponse = $loginResponse;
        $this->locale = $locale;
        $this->connectionTimeout = $connectionTimeout;
        $this->readWriteTimeout = $readWriteTimeout;
        $this->context = $context;
        $this->keepalive = $keepAlive;
        $this->heartbeat = $heartbeat;
    }

    /**
     * @return mixed
     */
    public function getHost()
    {
        return $this->host;
    }

    /**
     * @return mixed
     */
    public function getPort()
    {
        return $this->port;
    }

    /**
     * @return mixed
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * @return mixed
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * @return string
     */
    public function getVhost(): string
    {
        return $this->vhost;
    }

    /**
     * @return bool
     */
    public function isInsist(): bool
    {
        return $this->insist;
    }

    /**
     * @return string
     */
    public function getLoginMethod(): string
    {
        return $this->loginMethod;
    }

    public function getLoginResponse()
    {
        return $this->loginResponse;
    }

    /**
     * @return string
     */
    public function getLocale(): string
    {
        return $this->locale;
    }

    /**
     * @return float
     */
    public function getConnectionTimeout(): float
    {
        return $this->connectionTimeout;
    }

    /**
     * @return float
     */
    public function getReadWriteTimeout(): float
    {
        return $this->readWriteTimeout;
    }

    public function getContext()
    {
        return $this->context;
    }

    /**
     * @return bool
     */
    public function isKeepalive(): bool
    {
        return $this->keepalive;
    }

    /**
     * @return int
     */
    public function getHeartbeat(): int
    {
        return $this->heartbeat;
    }
}
