<?php

declare(strict_types=1);

namespace IssetBV\Queuing\AmqpBundle\DependencyInjection;

use IssetBV\Queuing\AmqpBundle\AMQP\Connection;
use IssetBV\Queuing\AmqpBundle\AMQP\ConnectionOptions;
use IssetBV\Queuing\Queue\ConnectionInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

/**
 * This is the class that loads and manages your bundle configuration.
 *
 * @see http://symfony.com/doc/current/cookbook/bundles/extension.html
 */
class IssetBVQueuingAmqpExtension extends Extension
{
    /**
     * @var ContainerBuilder
     */
    private $container;

    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $this->container = $container;
        foreach ($config['connections'] as $connection => $connectionSettings) {
            $this->buildConnection($connection, $connectionSettings);
        }
    }

    public function buildConnection(string $name, array $settings)
    {
        $optionsName = 'isset_bv_queuing.amqp.options.' . $name;
        $options = $this->container->register(
            $optionsName,
            ConnectionOptions::class
        );

        $options->addArgument($settings['host']);
        $options->addArgument($settings['port']);
        $options->addArgument($settings['user']);
        $options->addArgument($settings['password']);
        $options->addArgument($settings['vhost']);
        $options->addArgument($settings['insist']);
        $options->addArgument($settings['login_method']);
        $options->addArgument($settings['login_response']);
        $options->addArgument($settings['locale']);
        $options->addArgument($settings['connection_timeout']);
        $options->addArgument($settings['read_write_timeout']);
        $options->addArgument($settings['context']);
        $options->addArgument($settings['keepalive']);
        $options->addArgument($settings['heartbeat']);

        $connection = $this->container->register(
            ConnectionInterface::CONNECTION_PREFIX . $name,
            Connection::class
        );
        $connection->addArgument(new Reference($optionsName));
    }
}
