<?php

declare(strict_types=1);

namespace IssetBV\Queuing\AmqpBundle\AMQP;

use IssetBV\Queuing\Queue\QueueMessageInterface;
use PhpAmqpLib\Message\AMQPMessage as PhpAMPQMessage;
use PhpAmqpLib\Wire\AMQPTable;

class Message implements QueueMessageInterface
{
    /**
     * @var PhpAMPQMessage
     */
    private $message;

    public function __construct(PhpAMPQMessage $message = null)
    {
        if (null === $message) {
            $message = new PhpAMPQMessage();
        }
        $this->message = $message;
    }

    public function getBody(): string
    {
        return $this->message->getBody();
        // TODO: Implement getBody() method.
    }

    public function getHeader(string $header)
    {
        if (!$this->message->has('application_headers')) {
            return null;
        }
        $headers = $this->message->get('application_headers');
        /* @var AMQPTable $headers */
        foreach ($headers as $headerName => $headerValue) {
            if ($header === $headerName) {
                return $headerValue[1];
            }
        }

        return null;
    }

    public function setBody(string $body)
    {
        $this->message->setBody($body);
    }

    public function addHeader(Header $AMQPHeader)
    {
        if ($this->message->has('application_headers')) {
            $headers = $this->message->get('application_headers');
        } else {
            $headers = [];
        }

        $headers[$AMQPHeader->getHeader()] = [$AMQPHeader->getType(), $AMQPHeader->getValue()];
        $this->message->set('application_headers', $headers);
    }

    /**
     * @return PhpAMPQMessage
     */
    public function getMessage(): PhpAMPQMessage
    {
        return $this->message;
    }

    public function getOption(string $option)
    {
        if (!$this->message->has($option)) {
            return null;
        }

        return $this->message->get($option);
    }
}
