<?php

namespace TPC\QueueingBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Description of BartmanCommand
 *
 * @author Bart Malestein <bartmalestein88@gmail.com>
 */
class OneJobCommand extends ContainerAwareCommand
{

    private $em;
    private $container;

    protected function configure()
    {
        $this
                ->setName('issetbv:execute:job')
                ->addArgument('job', InputArgument::REQUIRED, 'You need one job')
                ->setDescription('Perform one job (ignore queue)');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->container = $this->getContainer();
        $this->em = $this->getContainer()->get('doctrine')->getManager();

        $job_id = $input->getArgument('job');

        $job = $this->em->getRepository($this->container->getParameter('Queue_repo'))->find($job_id);

        if (!empty($job)) {

            $controller = $this->getContainer()->get('Connector');
            $controller->doOneJob($job);

            $output->writeln('<info>Job started. Status ' . $job->getStatus()->getName() . '</info>');
        } else {

            $output->writeln('<error>Job doesn\'t exist</error>');
        }
    }

}

