<?php

namespace TPC\QueueingBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * QueueData
 *
 * @ORM\Table(name="queue_data")
 * @ORM\Entity
 */
class QueueData
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="basequeueId", type="integer")
     */
    private $basequeueId;

    /**
     * @var string
     *
     * @ORM\Column(name="key", type="string", length=255)
     */
    private $key;

    /**
     * @var string
     *
     * @ORM\Column(name="value", type="string", length=255)
     */
    private $value;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set basequeueId
     *
     * @param integer $basequeueId
     * @return QueueData
     */
    public function setBasequeueId($basequeueId)
    {
        $this->basequeueId = $basequeueId;
    
        return $this;
    }

    /**
     * Get basequeueId
     *
     * @return integer 
     */
    public function getBasequeueId()
    {
        return $this->basequeueId;
    }

    /**
     * Set key
     *
     * @param string $key
     * @return QueueData
     */
    public function setKey($key)
    {
        $this->key = $key;
    
        return $this;
    }

    /**
     * Get key
     *
     * @return string 
     */
    public function getKey()
    {
        return $this->key;
    }

    /**
     * Set value
     *
     * @param string $value
     * @return QueueData
     */
    public function setValue($value)
    {
        $this->value = $value;
    
        return $this;
    }

    /**
     * Get value
     *
     * @return string 
     */
    public function getValue()
    {
        return $this->value;
    }
}
