<?php

namespace TPC\QueueingBundle\Walker;

use Doctrine\ORM\Query\SqlWalker;

/**

  SortableNullsWalker
 */
class SortableNullsWalker extends SqlWalker
{

    const NULLS_FIRST = 'NULLS FIRST';
    const NULLS_LAST  = 'NULLS LAST';

    public function walkOrderByClause($orderByClause)
    {
        $sql = parent::walkOrderByClause($orderByClause);

        $nullFields = $this->getQuery()->getHint('SortableNullsWalker.fields');

        if (empty($nullFields) || !is_array($nullFields)) {
            return $sql;
        }


        return str_replace('DESC', 'DESC NULLS LAST', $sql);
    }

}