<?php

namespace TPC\QueueingBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * QueueType
 *
 * @ORM\Table(name="queue_type")
 * @ORM\Entity
 */
class QueueType {

    /**
     * @ORM\OneToMany(targetEntity="QueueBase", mappedBy="type")
     */
    private $queueItems;

    public function __construct() {
        $this->queueItems = new ArrayCollection();
    }

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", unique=true, length=255)
     */
    private $name;

    /**
     * @var string
     *
     * @ORM\Column(name="job_limit", type="string", length=255)
     */
    private $joblimit;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId() {
        return $this->id;
    }

    public function setName($name) {
        $this->name = $name;

        return $this;
    }

    public function getName() {
        return $this->name;
    }

    public function setJobLimit($joblimit) {
        $this->joblimit = $joblimit;

        return $this;
    }

    public function getJobLimit() {
        return $this->joblimit;
    }

    /**
     * Add queueItems
     *
     * @param \TPC\QueueingBundle\Entity\QueueBase $queueItems
     * @return States
     */
    public function addQueueItem(\TPC\QueueingBundle\Entity\QueueBase $queueItems) {
        $this->queueItems[] = $queueItems;
        return $this;
    }

    /**
     * Remove queueItems
     *
     * @param \TPC\QueueingBundle\Entity\QueueBase $queueItems
     */
    public function removeQueueItem(\TPC\QueueingBundle\Entity\QueueBase $queueItems) {
        $this->queueItems->removeElement($queueItems);
    }

    /**
     * Get queueItems
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getQueueItems() {
        return $this->queueItems;
    }

}