<?php

namespace TPC\QueueingBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * QueueStatus
 *
 * @ORM\Table(name="queue_status")
 * @ORM\Entity
 */
class QueueStatus {

    /**
     * @ORM\OneToMany(targetEntity="QueueBase", mappedBy="status")
     */
    private $queueItems;

    public function __construct() {
        $this->queueItems = new ArrayCollection();
    }

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", unique=true, length=255)
     */
    private $name;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId() {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return States
     */
    public function setName($name) {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName() {
        return $this->name;
    }

    /**
     * Add queueItems
     *
     * @param \TPC\QueueingBundle\Entity\QueueBase $queueItems
     * @return States
     */
    public function addQueueItem(\TPC\QueueingBundle\Entity\QueueBase $queueItems) {
        $this->queueItems[] = $queueItems;
        return $this;
    }

    /**
     * Remove queueItems
     *
     * @param \TPC\QueueingBundle\Entity\QueueBase $queueItems
     */
    public function removeQueueItem(\TPC\QueueingBundle\Entity\QueueBase $queueItems) {
        $this->queueItems->removeElement($queueItems);
    }

    /**
     * Get queueItems
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getQueueItems() {
        return $this->queueItems;
    }

}