<?php

namespace TPC\QueueingBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\JsonResponse;

class IdRestQueueController extends Controller
{

    /**
     * Remove queue item
     * @param int queue id
     * @return Response
     */
    public function deleteAction($id)
    {
        $ret = $this->get('IdRestQueue')
                ->delete($id);

        if ($ret) {
            $response = new JsonResponse(array('message' => 'Succes'));
        } else {
            $response = new JsonResponse(array('error' => $this->get('IdRestQueue')->getLastError()));
            $response->setStatusCode('404');
        }

        return $response;
    }

    /**
     * Pause queue item
     * @param int queue id
     * @return Response
     */
    public function pauseAction($id)
    {
        $ret = $this->get('IdRestQueue')
                ->pauseJob($id);

        if ($ret) {
            $response = new JsonResponse(array('message' => 'Succes'));
        } else {
            $response = new JsonResponse(array('error' => $this->get('IdRestQueue')->getLastError()));
            $response->setStatusCode('404');
        }

        return $response;
    }

    /**
     * Continue queue item
     * @param int queue id
     * @return Response
     */
    public function continueAction($id)
    {
        $ret = $this->get('IdRestQueue')
                ->continueJob($id);

        if ($ret) {
            $response = new JsonResponse(array('message' => 'Succes'));
        } else {
            $response = new JsonResponse(array('error' => $this->get('IdRestQueue')->getLastError()));
            $response->setStatusCode('404');
        }

        return $response;
    }

    /**
     * Show status of queue item
     * @param int queue id
     * @return Response
     */
    public function statusAction($id)
    {
        $ret = $this->get('IdRestQueue')
                ->status($id);

        if ($ret) {
            $response = new JsonResponse(array('status' => $ret));
        } else {
            $response = new JsonResponse(array('error' => $this->get('IdRestQueue')->getLastError()));
            $response->setStatusCode('404');
        }

        return $response;
    }

    /**
     * Update queue item
     * @param int queue id
     * @param json array with parameters to change
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function updateAction($id)
    {
        $ret = $this->get('IdRestQueue')
                ->update($id);

        if ($ret) {
            $response = new JsonResponse(array('status' => 'Succes'));
        } else {
            $response = new JsonResponse(array('error' => $this->get('IdRestQueue')->getLastError()));
            $response->setStatusCode('404');
        }

        return $response;
    }

    public function forceStartAction($id)
    {
        $ret = $this->get('IdRestQueue')
                ->forceStart($id);

        if ($ret) {
            $response = new JsonResponse(array('status' => 'Succes'));
        } else {
            $response = new JsonResponse(array('error' => $this->get('IdRestQueue')->getLastError()));
            $response->setStatusCode('404');
        }

        return $response;
    }

    /**
     * Show a job in json format
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function showJobAction($id)
    {
        $ret = $this->get('IdRestQueue')
                ->showJob($id);

        if ($ret) {
            $response = new JsonResponse($ret);
            $response->setStatusCode('200');
        } else {
            $response = new JsonResponse(array('error' => $this->get('RestQueue')->getLastError()));
        }
        return $response;
    }

}