<?php

namespace TPC\QueueingBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Description of BartmanCommand
 *
 * @author Bart Malestein <bartmalestein88@gmail.com>
 */
class NextJobCommand extends ContainerAwareCommand {

    protected function configure() {
        $this
                ->setName('issetbv:queue:get')
                ->addArgument('function', InputArgument::REQUIRED, 'next|continue|pause');
    }

    protected function execute(InputInterface $input, OutputInterface $output) {
        switch ($input->getArgument('function')) {
            case 'next':
                $controller = $this->getContainer()->get('Connector');
                $controller->nextjob();
                break;
            case 'continue':
                $controller = $this->getContainer()->get('RestQueue');
                $controller->continueQueue();
                break;
            case 'pause':
                $controller = $this->getContainer()->get('RestQueue');
                $controller->pauseQueue();
                break;
            case 'help':
                $output->writeln('<info>queue:get next</info>');
                $output->writeln('<comment>get the next job in queue</comment>');
                $output->writeln('<info>queue:get continue</info>');
                $output->writeln('<comment>continue the paused queue</comment>');
                $output->writeln('<info>queue:get pause</info>');
                $output->writeln('<comment>pause the queue</comment>');
                break;
            default:
                $output->writeln('<error>Invalid input</error>');
                $output->writeln('<info>queue:get next|continue|pause</info>');

                break;
        }
    }

}

