<?php

namespace TPC\QueueingBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Description of BartmanCommand
 *
 * @author Bart Malestein <bartmalestein88@gmail.com>
 */
class JobStatusCommand extends ContainerAwareCommand
{

    private $em;
    private $container;

    protected function configure()
    {
        $this
                ->setName('issetbv:change:job:status')
                ->addArgument('job_id', InputArgument::REQUIRED, 'id of the job')
                ->addArgument('status_name', InputArgument::REQUIRED, 'name of the status')
                ->setDescription('Switch a job status');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->container = $this->getContainer();
        $this->em        = $this->getContainer()->get('doctrine')->getManager();

        $jobId    = $input->getArgument('job_id');
        $statusName = $input->getArgument('status_name');

        $job = $this->em->getRepository($this->container->getParameter('Queue_repo'))->find($jobId);
        if ($job == null) {
            return $output->writeln('<error>Job doesn\'t exist</error>');
        }
        $status = $this->em->getRepository('TPCQueueingBundle:QueueStatus')->findOneByName($statusName);
        if ($job == null) {
            return $output->writeln('<error>Status doesn\'t exist</error>');
        }

        $job->setStatus($status);
        $this->em->flush();

        $output->writeln('<info>Job status switched</info>');
    }

}

