<?php

namespace TPC\QueueingBundle\Handlers\ApiHandling;

use Doctrine\ORM\EntityManager;
use Symfony\Component\DependencyInjection\Container;
use Symfony\Component\EventDispatcher\EventDispatcher;
use TPC\QueueingBundle\Event\PreInitEvent;
use TPC\QueueingBundle\Event\Events;

class RestQueueHandler
{

    private $em;
    private $ct;
    private $eventDispatch;
    private $lastError;

    public function __construct(EntityManager $em, Container $ct, EventDispatcher $eventDispatch)
    {
        $this->em = $em;
        $this->ct = $ct;
        $this->eventDispatch = $eventDispatch;

//        Testing purpose  
//        $listener = new \TPC\QueueingBundle\EventListener\DispatchListener();
//        $this->eventDispatch->addListener('queue.preinit', array($listener, 'onFooAction'));
    }

    public function getLastError()
    {
        return $this->lastError;
    }

    public function setLastError($error)
    {
        $this->lastError = $error;
    }

    /**
     * Add a job to the queue
     * @param array job parameters
     * @return string|boolean
     */
    public function addJob($params)
    {

        if (!isset($params['maxTries'])) {
            //default status
            $params['maxTries'] = $this->ct->getParameter('Queue_default_maxTries');
        }


//        $isPaused = $this->em->getRepository('TPCQueueingBundle:QueueConfig')
//                ->findOneByName('is_paused')
//                ->getValue();
        //this functionality isn't needed right now
//        if ($isPaused) {
//            $this->setLastError('queue is paused');
//            return false;
//        }
        if (!isset($params['status'])) {
            //default status
            $params['status'] = 'queued';
        }

        //Get status entity from database
        $status = $this->em->getRepository('TPCQueueingBundle:QueueStatus')
                ->findOneByName($params['status']);

        if (is_null($status)) {
            $this->setLastError('status does not exist');
            return false;
        } else {
            $params['status'] = $status;
        }

        if (!isset($params['type'])) {
            //default type
            $params['type'] = 'default';
        }

        //Get type entity from database
        $type = $this->em->getRepository('TPCQueueingBundle:QueueType')
                ->findOneByName($params['type']);

        if (empty($type)) {
            $type = new \TPC\QueueingBundle\Entity\QueueType();
            $type->setJobLimit(32);
            $type->setName($params['type']);
            $this->em->persist($type);
            $this->em->flush();
        }
        $params['type'] = $type;


        //Get queue entity from container
        $queue = $this->ct->get('QueueEntity');

        //Dispatch event
        $event = new PreInitEvent($queue, $params);
        $this->eventDispatch->dispatch(Events::PRE_INIT, $event);

        if ($event->getException()) {
            $this->setLastError($event->getException());
            return false;
        }


        //Initiate queue entity
        $ret = $queue->init($event->getParams());
        if (!$ret) {
            $this->setLastError('Init failed');
            return false;
        }

        //Validate object
        $errors = $this->ct->get('validator')->validate($queue);
        if (count($errors) > 0) {

            $flap = '';

            foreach ($errors as $error) {

                //remove newline
                $tmp = explode("\n", $error);

                $flap .= $tmp[0] . '' . $tmp[1] . ', ';
            }


            //Set validator error message as last error
            $this->setLastError($flap);
            return false;
        }

        //remember object 
        $this->em->persist($queue);
        //save changes
        $this->em->flush();

        //return identifier
        return $queue->getIdentifier();
    }

    /**
     * Show everything in the queue
     * @return array
     */
    public function showQueue()
    {
        $repo = $this->ct->getParameter('Queue_repo');

        if (isset($_REQUEST['min']) && isset($_REQUEST['max']) && isset($_REQUEST['time']) && isset($_REQUEST['status'])) {

            $data = $this->em->getRepository($repo)
                    ->showQueue($_REQUEST['min'], $_REQUEST['max'], $_REQUEST['time'], $_REQUEST['status']);
        } else {
            //get 1000 queue items max by default
            $data = $this->em->getRepository($repo)
                    ->showQueue($repo, 0, 1000, 365, 'all states');
        }

        return $data;
    }

    /**
     * Show total of each status in queue
     * @return array
     */
    public function showQueueStatus()
    {
        $hours = $this->ct->get('request')->query->get('hours');

        //Get repository location
        $repo = $this->ct->getParameter('Queue_repo');


        if (!empty($hours) && $hours === "all") {
            $response[] = $this->em->getRepository($repo)
                    ->getStatus($repo, 24);
            $response[] = $this->em->getRepository($repo)
                    ->getStatus($repo, 48);
            $response[] = $this->em->getRepository($repo)
                    ->getStatus($repo, 168);
            $response[] = $this->em->getRepository($repo)
                    ->getStatus($repo, 672);

            return $response;
        }

        //Custom method, returns and array with state and corresponding number
        //of queue items in that state
        $response = $this->em->getRepository($repo)
                ->getStatus($repo, $hours);

        return $response;
    }

    /**
     * Unpause the queue
     * @return boolean
     */
    public function continueQueue()
    {
        //Set pause parameter in config database to false
        $this->em->getRepository('TPCQueueingBundle:QueueConfig')
                ->findOneByName('is_paused')
                ->setValue(0);

        //Get queued status
        $queue = $this->em->getRepository('TPCQueueingBundle:QueueStatus')->findOneByName('queued');
        //Get busy status
        $busy = $this->em->getRepository('TPCQueueingBundle:QueueStatus')->findOneByName('busy');

        //Get all queue objects        
        $result = $this->em->getRepository($this->ct->getParameter('Queue_repo'))->findAll();
        //Loop trough queue objects
        foreach ($result as $queueItem) {
            //When queue object is paused, resume and notify controller
            if ($queueItem->getStatus()->getName() == 'paused') {
                $queueItem->setStatus($queue);
            } else if ($queueItem->getStatus()->getName() == 'interrupted') {
                $queueItem->setStatus($busy);
                //Resume job
                $connector = $this->ct->get('Connector');
                $connector->continueJob($queueItem);
            }
        }
        //save changes
        $this->em->flush();

        return true;
    }

    /**
     * Pause the queue
     * @return boolean
     */
    public function pauseQueue()
    {
        //Set pause parameter in config database to true
        $this->em->getRepository('TPCQueueingBundle:QueueConfig')
                ->findOneByName('is_paused')
                ->setValue(1);

        //Get Paused status
        $pause = $this->em->getRepository('TPCQueueingBundle:QueueStatus')->findOneByName('paused');
        //Get Paused status
        $interrupt = $this->em->getRepository('TPCQueueingBundle:QueueStatus')->findOneByName('interrupted');

        //Get all queue objects
        $result = $this->em->getRepository($this->ct->getParameter('Queue_repo'))->findAll();
        //Loop trough queue objects 
        foreach ($result as $queueItem) {
            //When queue object is queued, set to pause
            if ($queueItem->getStatus()->getName() == 'queued') {
                $queueItem->setStatus($pause);

                //when queue object is busy, pause and notify controller
            } else if ($queueItem->getStatus()->getName() == 'busy') {
                $queueItem->setStatus($interrupt);
                //TODO: pause job trough controller if possible
                $connector = $this->ct->get('Connector');
                $connector->pauseJob($queueItem);
            }
        }
        //save changes
        $this->em->flush();

        return true;
    }

    public function retryCallback()
    {
        $callback = $this->ct->get('issetbv.callback');

        $retryDays = -1;

        if (isset($_REQUEST['days'])) {
            $retryDays = $_REQUEST['days'];
        }

        $callback->retryCallback($retryDays);

        return true;
    }

}