<?php

namespace TPC\QueueingBundle\EventListener;

use TPC\QueueingBundle\Entity\QueueBase;
use Symfony\Component\DependencyInjection\Container;
use Doctrine\ORM\EntityManager;

/**
 * Description of StatusListener
 *
 * @author Bart Malestein <bartmalestein88@gmail.com>
 */
class StatusListener
{

    private $ct;
    private $preUpdate = array();
    private $entities = array();
    private $entitiesMsg = array();
    private $em;

    public function __construct(Container $ct)
    {
        $this->ct = $ct;
    }

    public function preUpdate($event)
    {
        $entity = $event->getEntity();
        $this->em = $event->getEntityManager();

        if ($entity instanceof QueueBase) {

            if ($event->hasChangedField('status')) {
                $this->entities[] = $entity;
                $old = $event->getOldValue('status');
                $url = $entity->getCallbackurl();

                //if failed and we have tries left, set to redo
                $status = $entity->getStatus()->getName();
                if ($status === 'failed') {

                    if ($entity->getTries() < $entity->getMaxTries()) {

                        $redo = $this->em->getRepository('TPCQueueingBundle:QueueStatus')
                                ->findOneByName('redo');

                        $entity->setStatus($redo);
                        $cur_tries = $entity->getTries();
                        $entity->setTries(++$cur_tries);
                    }
                }


                if (!empty($url)) {

                    $this->preUpdate[$entity->getIdentifier()] = $old->getName();
                }
            } else if ($event->hasChangedField('message')) {
                $url = $entity->getCallbackurl();

                if (!empty($url)) {
                    $this->entitiesMsg[] = $entity;
                }
            }
        }
    }

    public function postFlush()
    {
        $entities = $this->entities;
        $this->entities = array();
        foreach ($entities as $entity) {

            if ($entity instanceof QueueBase) {

                if (isset($this->preUpdate[$entity->getIdentifier()])) {

                    $callback = $this->ct->get('issetbv.callback');

                    $oldStatus = $this->preUpdate[$entity->getIdentifier()];

                    $params = array(
                        'identifier' => $entity->getIdentifier(),
                        'status' => $entity->getStatus()->getName(),
                        'oldStatus' => $oldStatus
                    );
                    $msg = $entity->getMessage();
                    if (!empty($msg)) {
                        $params['message'] = $entity->getMessage();
                    }

                    $repo = $this->ct->getParameter('Queue_repo');
                    //Array with queuedata objects
                    $data = $this->em->getRepository($repo)
                            ->getQueueData($entity);

                    if ($data) {
                        foreach ($data as $object) {
                            $params[$object->getKey()] = $object->getValue();
                        }
                    }

                    unset($this->preUpdate[$entity->getIdentifier()]);

                    $callback->add($entity->getCallbackurl(), $params, $entity->getIdentifier());
                }
            }
        }

        $entitiesMsg = $this->entitiesMsg;
        $this->entitiesMsg = array();

        foreach ($entitiesMsg as $entity) {

            if ($entity instanceof QueueBase) {
                $callback = $this->ct->get('issetbv.callback');

                $params = array(
                    'identifier' => $entity->getIdentifier(),
                    'status' => $entity->getStatus()->getName(),
                    'message' => $entity->getMessage()
                );

                $callback->add($entity->getCallbackurl(), $params, $entity->getIdentifier());
            }
        }
    }

}

